﻿using Connection.Class;
using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using WBP_Home_A_BT.Class;

namespace WBP_Home_A_BT_API_Demo {

    /// <summary>
    /// MainWindow.xaml 的互動邏輯
    /// </summary>
    public partial class MainWindow : Window {

        public MainWindow() {
            Closing += Form_Closing;

            InitializeComponent();
            System.Reflection.Assembly assembly = System.Reflection.Assembly.GetExecutingAssembly();

            Assembly WBP_Home_A_BTInfo = Assembly.GetAssembly(typeof(WBP_Home_A_BT.WBP_Home_A_BT));
            string WBP_Home_A_FileVersion = FileVersionInfo.GetVersionInfo(WBP_Home_A_BTInfo.Location).FileVersion;
            Title = $"{assembly.GetName().Name} v{assembly.GetName().Version}           {WBP_Home_A_BTInfo.GetName().Name}  v{WBP_Home_A_FileVersion}";
        }

        private static WBP_Home_A_BT.WBP_Home_A_BT home;
        private string key = "";


        private void Form_Closing(object sender, CancelEventArgs e) {
        }

        private void Home_OnDisConnected() {
            try {
                Dispatcher.Invoke(() => {
                    Label_DevicePath.Content = "";
                    button_BLE.IsEnabled = true;
                    button_Send.IsEnabled = false;
                });
            } catch { }
        }

        private void Home_OnConnected() {
            Dispatcher.Invoke(() => {
                Label_DevicePath.Content = home.DevicePath;
                button_BLE.IsEnabled = false;
                button_Send.IsEnabled = true;
            });
        }

        private async void Button_Send_Click(object sender, EventArgs e) {
            (bool Success, Command Command) callback;
            StringBuilder sb = new StringBuilder();
            switch (comboBox1.SelectedIndex) {
                case 0: //Read user ID and version data from BPM
                    callback = await home.SendMessageAsync(WBP_Home_A_BT.SendMessage.ToCommand.userInfoRead());
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    } else {
                        UserInfo info = (UserInfo)callback.Command.Data;
                        Connection.GlobalFunction.PrintAllProperties(info, ref sb);
                        textBox_NewID.Text = info.UserID;
                    }
                    break;

                case 1: //Write device Time to BPM
                    callback = home.SendMessage(WBP_Home_A_BT.SendMessage.ToCommand.timeWrite(DateTime.Now));
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    } else                     
                        sb.Append("Time had been sync");
                    break;

                case 2: //Read device Time from BPM
                    callback = home.SendMessage(WBP_Home_A_BT.SendMessage.ToCommand.timeRead());
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    } else { 
                        DateTime dateTime = (DateTime)callback.Command.Data;
                        sb.Append(dateTime.ToString("yyyy-MM-dd HH:mm:ss"));
                    }
                    break;

                case 3: //Read usual mode data from BPM
                    Mouse.OverrideCursor = Cursors.Wait;
                    callback = await home.SendMessageAsync(WBP_Home_A_BT.SendMessage.ToCommand.dataReadUsual());
                    Mouse.OverrideCursor = null;
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    } else {
                        List<Data> CasualData = (List<Data>)callback.Command.Data;

                        if (CasualData.Count > 0) {
                            sb.Append("\t" + "\t" + "\t");
                            sb.Append("\t" + "Sys" + "\t" + "Dia" + "\t" + "Hr" + "\t" + "Arr");
                            sb.Append("\r\n");
                            int i = 0;
                            for (i = 0; i < CasualData.Count; i++) {
                                sb.Append(i.ToString() + "\t" + CasualData[i].MeasureDateTime.ToString("yyyy-MM-dd") + "\t" + CasualData[i].MeasureDateTime.ToString("HH:mm:ss"));
                                sb.Append("\t" + CasualData[i].Systole.ToString() + "\t" + CasualData[i].Diastole.ToString() + "\t" + CasualData[i].Pulse.ToString() + "\t" + CasualData[i].Arr.ToString());
                                sb.Append("\r\n");
                            }
                        } else {
                            sb.Append("No Casual Data");
                        }
                    }
                    break;

                case 4: //Read diagnostic mode data from BPM
                    Mouse.OverrideCursor = Cursors.Wait;
                    callback = await home.SendMessageAsync(WBP_Home_A_BT.SendMessage.ToCommand.dataReadDiagnostic());
                    Mouse.OverrideCursor = null;
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");                        
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    } else {
                        List<Data> DiagnosticData = (List<Data>)callback.Command.Data;

                        if (DiagnosticData.Count >= 3) {
                            sb.Append("\t" + "\t" + "\t");
                            sb.Append("\t" + "Sys" + "\t" + "Dia" + "\t" + "Hr" + "\t" + "Arr");
                            sb.Append("\r\n");
                            int i = 0;
                            for (i = 0; i < DiagnosticData.Count - 3; i++) {
                                if (DiagnosticData[i].Systole > 0) {
                                    sb.Append(i.ToString() + "\t" + DiagnosticData[i].MeasureDateTime.ToString("yyyy-MM-dd") + "\t" + DiagnosticData[i].MeasureDateTime.ToString("HH:mm:ss"));
                                    sb.Append("\t" + DiagnosticData[i].Systole.ToString() + "\t" + DiagnosticData[i].Diastole.ToString() + "\t" + DiagnosticData[i].Pulse.ToString() + "\t" + DiagnosticData[i].Arr.ToString());
                                    sb.Append("\r\n");
                                }
                            }
                            for (i = DiagnosticData.Count - 3; i < DiagnosticData.Count; i++) {
                                sb.Append("average" + "\t" + DiagnosticData[i].DateType.ToString() + "\t" + "\t");
                                sb.Append("\t" + DiagnosticData[i].Systole.ToString() + "\t" + DiagnosticData[i].Diastole.ToString() + "\t" + DiagnosticData[i].Pulse.ToString() + "\t");
                                sb.Append("\r\n");
                            }
                        } else {
                            sb.Append("No Diagnostic Data");
                        }
                    }
                    break;

                case 5: //Clear select mode history data of the BPM
                    bool Usual_flag = (bool)checkBox_Clear_Usual.IsChecked;
                    bool Diag_flag = (bool)checkBox_Clear_Diag.IsChecked;
                    callback = home.SendMessage(WBP_Home_A_BT.SendMessage.ToCommand.dataClearSelectMode(Diag_flag,Usual_flag));
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    } else
                        sb.Append("The selected mode memory has been cleared");
                    break;
                    
                case 6: //Clear current mode history data of the BPM
                    callback = home.SendMessage(WBP_Home_A_BT.SendMessage.ToCommand.dataClearCurrentMode());
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");                      
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    } 
                    else
                        sb.Append("The current mode memory has been cleared");
                    break;

                case 7: //Write a new user ID to BPM
                    callback = home.SendMessage(WBP_Home_A_BT.SendMessage.ToCommand.userIDWrite(textBox_NewID.Text));
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    }
                    else
                        sb.Append("New ID have writed");
                    break;
                case 8: //Read serial number from BPM
                    callback = home.SendMessage(WBP_Home_A_BT.SendMessage.ToCommand.deviceSNRead());
                    if (callback.Command.CMD == (byte)WBP_Home_A_BT.Enum.Command.NACK) {
                        sb.Append("NACK");
                    } else if (!callback.Success) {
                        sb.Append("No call back,Please try again");
                    }
                    else { 
                    string sn = (string)callback.Command.Data;
                    Connection.GlobalFunction.PrintAllProperties(sn, ref sb);
                    textBox_NewSN.Text = sn;
                    }
                    break;

                case 9: //Disconnect the Bluetooth with BPM
                    bool DisconnectFromBLE = await home.DisconnectWithBLE();
                    if (DisconnectFromBLE) {
                        Home_OnDisConnected();
                        sb.Append("Bluetooth disconnection successful");
                    } else {
                        sb.Append("Bluetooth disconnection failed");
                    }
                    break;
            }
            richTextBox1.SetText(sb.ToString());
        }

        bool StringToBool(string value) {
            if (value.Contains("False") || value.Contains("false") || value.Equals(""))
                return false;
            else
                return true;
        }
        bool ComboToBool(int value) {
            if (value == 0)
                return false;
            else
                return true;
        }
        int StringToInt(string value) {
            if (value.Equals(""))
                return 0;
            else
                return int.Parse(value);
        }
        int BooltoSelectIndex(bool value) {
            if (value == false)
                return 0;
            else
                return 1;

        }

        private void Button2_Click(object sender, EventArgs e) {
            try {
                key = textBox_key.Text;
                home = new WBP_Home_A_BT.WBP_Home_A_BT(key);
                home.OnConnected += Home_OnConnected;
                home.OnDisConnected += Home_OnDisConnected;
                home.InitDeviceWatcher();
                button_BLE.IsEnabled = true;
                textBox_key.IsEnabled = false;
                (sender as Button).IsEnabled = false;
            } catch (Exception ee) {
                MessageBox.Show(ee.Message);
            }
        }




        public static string ToHexString(byte[] bytes) // 0xae00cf => "AE00CF "
{
            string hexString = string.Empty;
            if (bytes != null) {
                StringBuilder strB = new StringBuilder();
                for (int i = 0; i < bytes.Length; i++) {
                    strB.Append(bytes[i].ToString("X2"));
                    strB.Append(" ");
                }
                hexString = strB.ToString();
            }
            return hexString;
        }

        [STAThread]
        private async void Button_BLE_Click(object sender, EventArgs e) {
            if (!Connection.GlobalFunction.WinRT_API_Support) {
                MessageBox.Show("Operating system requires Windows 10 1803 or higher!");
                return;
            }
            Window_BluetoothDiscover form_BLE_Discover = new Window_BluetoothDiscover();

            form_BLE_Discover.ShowDialog();
            switch (form_BLE_Discover.BLEAction) {
                case BLEAction.Connect:
                    home?.Dispose();
                    home = new WBP_Home_A_BT.WBP_Home_A_BT(key);
                    home.OnConnected += Home_OnConnected;
                    home.OnDisConnected += Home_OnDisConnected;
                    var connectionResult = await home.ConnectWithBLE(form_BLE_Discover.BLE_ID);
                    if (connectionResult.ErrorMessage == "Device is unreachable (i.e. out of range or shutoff)") {
                        MessageBox.Show("Please check the connection or unpair BLE, both of PC and blood pressure monitor.");
                        Home_OnDisConnected();
                    }
                    break;
            }
        }

    }
}